<div class="install">
    <div class="page-header">
        <h2><?php echo $title_for_layout; ?></h2>
    </div>
    <?php
    $check = true;

    // tmp is writable
    if (is_writable(TMP)) {
        echo '<div class="alert alert-success" role="alert">' . __('Your tmp directory is writable.') . '</div>';
    } else {
        $check = false;
        echo '<div class="alert alert-danger" role="alert">' . __('Your tmp directory is NOT writable.') . '</div>';
    }


    // config is writable
    if (is_writable(APP . 'Config')) {
        echo '<div class="alert alert-success" role="alert">' . __('Your config directory is writable.') . '</div>';
    } else {
        $check = false;
        echo '<div class="alert alert-danger" role="alert">' . __('Your config directory is NOT writable.') . '</div>';
    }
    
    // php version
    $minPhpVersion = '5.3.10';
    $operator      = '>=';
    if (version_compare(phpversion(), $minPhpVersion, $operator)) {
        echo '<div class="alert alert-success" role="alert">' . sprintf(__('PHP version %s %s %s'), phpversion(), $operator, $minPhpVersion) . '</div>';
    } else {
        $check = false;
        echo '<div class="alert alert-danger" role="alert">' . sprintf(__('PHP version %s < %s'), phpversion(), $minPhpVersion) . '</div>';
    }
    
    // mod_rewrite extension
    /*
    if ( function_exists( 'apache_get_modules' ) && in_array( 'mod_rewrite', apache_get_modules() ) ) {
        echo '<div class="alert alert-success" role="alert">' . __( 'mod_rewrite module is enabled.' ) . '</div>';
    } else {
        $check = false;
        echo '<div class="alert alert-danger" role="alert">' .  __( 'mod_rewrite module is not enabled.' ) . '</div>';
    }
    */
    
    // mcrypt extension
    if (extension_loaded('mcrypt')) {
        echo '<div class="alert alert-success" role="alert">' . __('Your version of PHP has the mcrypt extension loaded.') . '</div>';
    } else {
        $check = false;
        echo '<div class="alert alert-danger" role="alert">' .  __('Your version of PHP does NOT have the mbstring extension loaded.') . '</div>';
    }
    
    // allow_url_fopen
    if (ini_get('allow_url_fopen')) {
        echo '<div class="alert alert-success" role="alert">' . __('allow_url_fopen is enabled.') . '</div>';
    } else {
        $check = false;
        echo '<div class="alert alert-danger" role="alert">' .  __('allow_url_fopen is disabled.') . '</div>';
    }
    
    if (class_exists('\DOMDocument')) {
        echo '<div class="alert alert-success" role="alert">' . __('Able to load DOMDocument class.') . '</div>';
    } else {
        $check = false;
        echo '<div class="alert alert-danger" role="alert">' .  __('Unable to load DOMDocument class.') . '</div>';
    }
    ?>
</div>
<?php
if ($check) {
    $out = $this->Html->link(__('Install'), array( 'action' => 'database' ), array( 'label' => 'Submit', 'class' => 'btn btn-success' ));
} else {
    $out = '<div class="alert alert-danger" role="alert"><b>' . __('Installation cannot continue as minimum requirements are not met.') . '</b></div>';
}

echo $out;
